function [] = subsetoverlap_dir()
%This function uses subsetoverlap to process synapse subset directory, use
%work similar to syn_collate, except it replicates the original directory in
%another root.
%Synatax:   [] = subsetoverlap_dir();
%Input:     you will be prompted to point to the root of the directory
%               structure.
%Output:    no output

%get the directories
dir_root = uigetdir2('','Directory of subclass');
dirsav = uigetdir3('','Directory to save the data of subclass');

dir_lv1 = dir(dir_root);    %get the file structure of the root dir.

%now lets crank through the directories
for i = 3:size(dir_lv1,1)   %level 1: always start on 3 as 1 and 2 are . and .. (Dir: 20110308...etc.)
    if dir_lv1(i).isdir     %if this is a directory continue; else case...who cares
        dir_lv2 = dir([dir_root,filesep,dir_lv1(i).name]);  %now get the directory structure of the next level
        dir_tmp = [dir_root,filesep,dir_lv1(i).name,filesep]; %the current level 2 directory 
        dirsav_tmp = [dirsav,filesep,dir_lv1(i).name,filesep];
        if i==3
            mkdir(dirsav,dir_lv1(i).name);
        end
        if dir_end(dir_lv2)     %Test if this is the end level
            %Get here later
            error('There is a strict directory structure, and this is not it.');    %did not mean to use a strict directory structure
            %But storing an x possible drill down directory structure in a
            %n possible cell array, turns out to be too unwieldy.  Look at
            %the stored ver0.2 if you want to resurrect this, but for now
            %we are deadlocking this.  Check dir_struct.dia for the proper
            %directory structure.
        else    %not the end yet(expected)
            for j = 3:size(dir_lv2,1)   %level 2: Care about the name of this level (Dir: WT, KO, etc.)
                if dir_lv2(j).isdir     %if is a directory continue; else case not important.
                    dir_lv3 = dir([dir_tmp,dir_lv2(j).name]);   %get the third level
                    dir_tmp2 = [dir_tmp,dir_lv2(j).name,filesep];  %the current level3 directory
                    dirsav_tmp2 = [dirsav_tmp,dir_lv2(j).name,filesep];
                    if j==3
                        mkdir(dirsav_tmp,dir_lv2(j).name);
                    end
                    if dir_end(dir_lv3)
                        %Come back for this later
                        error('There is a strict directory structure, and this is not it.');
                    else    %no the end yet(expected)
                        for k = 3:size(dir_lv3,1)   %level 3: The care about level (Dir: Layer23, Layer4, etc.)
                            if dir_lv3(k).isdir     %go forth; we don't care about files
                                dir_lv4 = dir([dir_tmp2,dir_lv3(k).name]);   %get the fourth level
                                dir_tmp3 = [dir_tmp2,dir_lv3(k).name,filesep];  %the current level 4 directory
                                dirsav_tmp3 = [dirsav_tmp2,dir_lv3(k).name,filesep];
                                if k==3
                                    mkdir(dirsav_tmp2,dir_lv3(k).name);
                                end
                                if dir_end(dir_lv4)
                                    error(['There is a strict directory structure, and this is not it.',dir_tmp3]);
                                else
                                    for l = 3:size(dir_lv4,1)   %level4: Men's Wear (Dir: R1, R2, etc.)
                                        if dir_lv4(l).isdir
                                            dir_lv5 = dir([dir_tmp3,dir_lv4(l).name]);  %get the fifth level
                                            dir_tmp4 = [dir_tmp3,dir_lv4(l).name]; %The current level 5 directory
                                            dirsav_tmp4 = [dirsav_tmp3,dir_lv4(l).name];
                                            mkdir(dirsav_tmp3,dir_lv4(l).name);
                                            if dir_end(dir_lv5) 
                                                error('There is a strict directory structure, and this is not it.');
                                            else
%                                                 for m = 3:size(dir_lv5,1)   %level5: One more to go (Dir: VGluT1, VGluT2, etc.)
%                                                    if dir_lv5(m).isdir
%                                                         dir_lv6 = dir([dir_tmp4,dir_lv5(m).name]);   %The end level
%                                                         dir_tmp5 = [dir_tmp4,dir_lv5(m).name];
%                                                         dirsav_tmp5 = [dirsav_tmp4,dir_lv5(m).name];
                                                        %we only care about the files now.
                                                        if size(dir_lv5,1)>2    %no empty directories
                                                            subsetoverlap('dir1',dir_tmp4,'dirsav',dirsav_tmp4);     %reprocess the files
                                                        end
%                                                     end
%                                                 end
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
    end
end
                   
        
        
%--------------------------------------------------------------------------
%sub function to figure out if this level is only files, meaning this is
%the end dir.
function [is_end] = dir_end(dir_struct)

is_end = 0;  %initiate

for i = 3:size(dir_struct,1)    %go through the 
    is_end(i-2)=dir_struct(i).isdir;     %pull the isdir info
end

is_end = logical(1-max(is_end));       %readout of whether this directory has only files.